#!/usr/bin/perl

################################
##  Save state and stop all running Virtualbox VMs.
##  By Chris Biltcliffe
##  CB Services
##  C-Box
##  Copyright Feb 24, 2014
##  All rights reserved
################################

$runningVMlist = `vboxmanage list runningvms`;

while ($runningVMlist =~ s/\{([0-9a-f]{8}\-[0-9a-f]{4}\-[0-9a-f]{4}\-[0-9a-f]{4}\-[0-9a-f]{12})\}//)
	{
	$VMguid = $1;
	print "Need to shut down GUID: ".$VMguid." .\n";
	$result = `vboxmanage controlvm $VMguid savestate`;
}


